import React from "react";
import { List } from "react-virtualized";
import { v4 as uuidv4 } from "uuid";
import { AutoSizer } from "react-virtualized";
class Imu extends React.Component {
  state = {
    data: [],
  };

  constructor(props) {
    super(props);
    this.state = {
      data: [],
    };
  }

  componentDidMount() {
    this.props.socket.on("ImuData", (res) => {
      let mydata = [res, ...this.state.data];
      this.setState({ data: mydata });
      // this.state.data=[]
    });
  }

  rowRenderer = ({ index, isScrolling, key, style }) => {
    if (index > 0) {
      return "";
    }
    return (
      <div key={`liMessages_${uuidv4()}`}>
        <div>
          <div className="col-4 float-left text-right bold">X :</div>
          <span>{this.state.data[index].x}</span>
        </div>
        <div>
          <div className="col-4 float-left text-right bold">Y :</div>
          <span>{this.state.data[index].y}</span>
        </div>
        <div>
          <div className="col-4 float-left text-right bold">Z :</div>
          <span>{this.state.data[index].z}</span>
        </div>
      </div>
    );
  };

  render() {
    const height = this.props.height;
    const rowHeight = this.props.height;
    const width = this.props.width;
    return (
      <div
        className={
          "border p-1 rounded pb-3 border-2  " +
          (true ? "border-success " : "border-danger")
        }
      >
        <h6>IMU</h6>

        <List
          rowCount={this.state.data.length}
          width={width}
          height={height }
          rowHeight={height }
          rowRenderer={this.rowRenderer}
          overscanRowCount={3}
        />


      </div>
    );
  }
}
export default Imu;
